#include <xc.h>
#include <stdint.h>

#include "i2c.h"

void i2c_init(void)
{

    // SMP Standard Speed; CKE disabled; 
    SSP1STAT = 0x80;
    // SSPEN enabled; CKP Idle:Low, Active:High; SSPM FOSC/4_SSPxADD_I2C; 
    SSP1CON1 = 0x28;
    // SBCDE disabled; BOEN disabled; SCIE disabled; PCIE disabled; DHEN disabled; SDAHT 100ns; AHEN disabled; 
    SSP1CON3 = 0x00;
    // SSPADD 79; 
    SSP1ADD = 0x09;  
}

void i2c_start(void)
{
    SSP1CON2bits.SEN = 1;
    while (SSP1CON2bits.SEN);
}

void i2c_stop(void)
{
    SSP1CON2bits.PEN = 1;
    while (SSP1CON2bits.PEN);
}

void i2c_restart(void)
{
    SSP1CON2bits.RSEN = 1;
    while (SSP1CON2bits.RSEN);
}

uint8_t i2c_read(uint8_t nack)
{
    uint8_t retval;
    
    SSP1CON2bits.RCEN = 1;
    while (SSP1STATbits.BF == 0);
    retval = SSP1BUF;
    // 0 for ACK, 1 for NACK
    SSP1CON2bits.ACKDT = nack;
    // Now send it
    SSP1CON2bits.ACKEN = 1;
    while (SSP1CON2bits.ACKEN);
    
    return retval;
}

/* returns ACK or NACK (0 for ACK, 1 for NACK)*/
uint8_t i2c_write(uint8_t data)
{
    PIR1bits.SSP1IF = 0;
    SSP1BUF = data;
    while (PIR1bits.SSP1IF == 0);
    return SSP1CON2bits.ACKSTAT;
}
