;--------------------------------------------------------------------------------------------------------------------------------
;MSN Messenger for mIRC
;Loading Script
;(c) Andy Carvell 2008-2010
;andy@burningimage.net
;--------------------------------------------------------------------------------------------------------------------------------

on *:LOAD:{
  set %msn.log 1
  set %msn.chat.style $no
  set %msn.useproxy no
  set %msn.server messenger.hotmail.com
  set %msn.server.port 1863
  set %msn.sounds on
  set %msn.messenger.font Verdana 12
  set %msn.maxidle 600
  set %msn.autoidle yes
  set %msn.showtype YES
  set %msn.motd Welcome to MSN Messenger for mIRC!
  set %msn.background $yes
  set %msn.autoconnect $no
  set %msn.awaysync $no
  set %msn.mailnotification yes
  set %msn.chat.style msn
  set %msn.chatwindow.style $yes
  set %msn.window.minimise $no
  set %msn.showlogon $yes
  set %msn.firsttime 0
  set %msn.flash yes
  unset %msn.pass
  echo -a ---
  echo -a MSN Messenger for mIRC
  echo -a /msn to connect.
  echo -a /msncontrol for the control panel.
  echo -a Alternatively, use the menu in mIRC.
  echo -a 
  echo -a Commands:
  echo -a /msn.name <new msn name>
  echo -a /msn.status <status> (type /msn.status help for more information)
  echo -a /msn.say <email address> <message>
  echo -a /msn.logs  
  echo -a ---
  if ( $version < 6.2) { echo -a  $+ MSN Messenger for mIRC prefers mIRC versions 6.2 and above.  You are very likely to encounter errors.  Please upgrade mIRC. }
  set %msn.sortbygroup $?!"Would you like to sort your contact list by MSN group? $crlf $crlf $+ You can change this option later in the control panel."
  if ( %msn.sortbygroup == $true ) { set %msn.sortbygroup $yes }
  set %msn.showoffline $?!"Would you like to display offline contacts? $crlf $crlf $+ You can change this option later in the control panel."
  if ( %msn.showoffline == $true ) { set %msn.showoffline $yes }

  ;.rename $shortfn($scriptdir $+ msn\msn.mr_) $shortfn($scriptdir $+ msn\msn.mrc)
  ;if the dll's already exist then don't copy them cos they'll be in use
  if ($sslready == $true) { 
    .copy -o " $+ $shortfn($scriptdir $+ *.txt) $+ " " $+ $shortfn($mircdir) $+ "
    .copy -o " $+ $shortfn($scriptdir $+ *.mrc) $+ " " $+ $shortfn($mircdir) $+ "
  }
  else {
    .copy -o " $+ $shortfn($scriptdir $+ *.txt) $+ " " $+ $shortfn($mircdir) $+ "
    .copy -o " $+ $shortfn($scriptdir $+ *.mrc) $+ " " $+ $shortfn($mircdir) $+ "
    .copy -o " $+ $shortfn($scriptdir $+ *.dll) $+ " " $+ $shortfn($mircdir) $+ "
    ;also copy dll's to mirc dir
    .copy -o " $+ $shortfn($scriptdir $+ *.dll) $+ " " $+ $shortfn($nofile($mircexe)) $+ "
  }
  .mkdir $shortfn($mircdir) $+ msn
  .mkdir $shortfn($mircdir) $+ msn\downloads
  .mkdir $shortfn($mircdir) $+ msn\dll

  if ($exists($shortfn($mircdir) $+ msn\dll\listfiles.dll) == $false) {
    .copy -o " $+ $shortfn($scriptdir $+ msn\dll\*) $+ " " $+ $shortfn($mircdir) $+ msn\dll $+ "
  }

  .copy -o " $+ $shortfn($scriptdir $+ msn\*) $+ " " $+ $shortfn($mircdir) $+ msn $+ "
  ;.rename $shortfn($scriptdir $+ msn\msn.mrc) $shortfn($scriptdir $+ msn\msn.mr_)
  .load -rs $shortfn($mircdir) $+ msn\msn.mrc
  set %msn.result $?!"Successfully installed. $crlf $crlf $+ MSN for mIRC will not work until you restart mIRC, would you like to restart mIRC now? $crlf $crlf $+ Type /msn to start MSN for mIRC once it's restarted."
  if (%msn.result == $true ) { exit -nr }
  set %msn.dir $gettok($mircexe,1- $+ $calc($numtok($mircexe,92)-1),92)
  halt

  :error
  if ($shortfn($nofile($mircexe)) isin $error) { 
    set %msn.result $?!"ADMIN RIGHTS REQUIRED $crlf $crlf $+ The installer has been unable to copy the required DLLs into the mIRC application directory ( $+ $nofile($mircexe) $+ ). This is because you are currently running mIRC without admin rights. $crlf $crlf $+ In order to rectify this, you should run the MSN for mIRC installer with admin rights.  In order to do this, find mIRC in your start menu, right click it and click 'Run as administrator'.  Once you've done this, rerun this installer in mIRC (example: /load -rs c:\temp\msninstall.mrc).  Once the installer has successfully completed, there is no need to click 'Run as administrator' again, just use mIRC as you did before. $crlf $crlf $+ For more information, please read SSL.txt. $crlf $crlf $+ Would you like to close mIRC now?"
    if (%msn.result == $true) { exit }
    reseterror
    haltdef
  }
}
