/* -------------------------------------------- */
/* DECODE VAUXHALL/OPEL AND PEUGEOT KEY FOBS 	*/
/* 				ANDY CARVELL 2011 				*/
/* 			  ANDY@BURNINGIMAGE.NET 			*/ 
/*--------------------------------------------- */

#include <htc.h>
#include "lcd.c"
#include "serial.c"

__CONFIG(1, IESODIS & FCMDIS & RCIO);
__CONFIG(2, BORV22 & BOREN & PWRTDIS & WDTDIS);
__CONFIG(3, MCLRDIS & HFSTABLE & LPT1DIS & PBANALOG);
__CONFIG(4, XINSTDIS & LVPDIS & STVREN);
__CONFIG(5, UNPROTECT);
__CONFIG(6, WRTEN);

/* define the car type, only one should be set */
char gm, pug;

unsigned int codelength[512];
char manc[1024];
unsigned char codestring[24];

long high, middle;
int low;
short long puglow;

int i;
char valid=0, pugincode=0;
char preamblecount = 0;
	
void puganalysecode(void);
void gmanalysecode(void);
void converttostring(void);

unsigned char tmp;

void puganalysecode(void) {
	int k;
	int manccount=0;
	
	for (k=2;k<512;k++) {
		/* if it's a 1 */
		if (!(k % 2)) {
			if ((codelength[k] > 1300) && (codelength[k] < 4000)) {
				manc[manccount] = 1; manc[manccount+1] = 1;
				manccount += 2;		
			}		
			else {
				manc[manccount] = 1;
				manccount += 1;		
			}	
		}	
		if (k % 2) {
			if ((codelength[k] > 1300) && (codelength[k] < 4000)) {
				manc[manccount] = 0; manc[manccount+1] = 0;
				manccount += 2;		
			}		
			else {
				manc[manccount] = 0;
				manccount += 1;		
			}	
		}
	}
	/* now decode the manchester coding to get the result */
	for (k=0;k<64;k+=2) high = (high << 1) | manc[k];		
	for (k=64;k<128;k+=2) middle = (middle << 1) | manc[k];	
	for (k=128;k<176;k+=2) puglow = (puglow << 1) | manc[k];
	
	converttostring();
}
		
void gmanalysecode(void) {
	int k;
	int manccount=0;
	
	for (k=3;k<512;k++) {
		/* if it's a 1 */
		if (k % 2) {
			if (codelength[k] > 3274) {
				manc[manccount] = 1; manc[manccount+1] = 1;
				manccount += 2;		
			}		
			else {
				manc[manccount] = 1;
				manccount += 1;		
			}	
		}	
		if (!(k % 2)) {
			if (codelength[k] > 2212) {
				manc[manccount] = 0; manc[manccount+1] = 0;
				manccount += 2;		
			}		
			else {
				manc[manccount] = 0;
				manccount += 1;		
			}	
		}
	}
	/* now decode the manchester coding to get the result */
	for (k=0;k<64;k+=2) high = (high << 1) | manc[k];
	for (k=64;k<128;k+=2) middle = (middle << 1) | manc[k];	
	for (k=128;k<160;k+=2) low = (low << 1) | manc[k];
	
	if ((low == 0x63C9) || (low == 0x9C36) || (low == 0x41EB) || (low == 0xBE14)) { converttostring(); }			
}
	
void converttostring(void) {
	char k;
	for (k=0;k<7;k++) {
		tmp = high >> (28-(4*k));
		codestring[k] = (tmp & 0xF);
	}	
	codestring[7] = (high & 0xF);
	
	for (k=8;k<15;k++) {
		tmp = middle >> (28-(4*(k-8)));
		codestring[k] = (tmp & 0xF);	
	}	
	codestring[15] = (middle & 0xF);
	
	if (gm) {
		for (k=16;k<19;k++) {
			tmp = low >> (12-(4*(k-16)));
			codestring[k] = (tmp & 0xF);
		}	
		codestring[19] = (low & 0xF);		
	}	

	if (pug) {
		for (k=16;k<21;k++) {
			tmp = puglow >> (20-(4*(k-16)));
			codestring[k] = (tmp & 0xF);
		}	
		codestring[21] = (puglow & 0xF);
	}

	/* now convert it to a string */
	for (k=0;k<24;k++) {
		if (codestring[k] < 0xA) codestring[k] += 48;
		else codestring[k] += 55;
	}	
	
	lcd_clear();
	lcd_home();
	
	for (k=0;k<6;k++) { lcd_data(codestring[k]); putch(codestring[k]); }
	lcd_cursor(0x40);
	for (k=6;k<16;k++) { lcd_data(codestring[k]); putch(codestring[k]); }
	if (gm) {
		lcd_data(32);
		for (k=16;k<20;k++) { lcd_data(codestring[k]); putch(codestring[k]); }
	}
	else {
		for (k=16;k<22;k++) { lcd_data(codestring[k]); putch(codestring[k]); }
	}	
	putch(0xD); putch(0xA);		
}

	
void main(void) {
	
	OSCCON = OSCCON | 0b01110000;
	
	ANSEL = 0;
	ANSELH = 0;
	
	PORTB = 0;
	PORTC = 0;
	TRISB = 0xFF;
	TRISC = 0;
	
	WPUB = 0x08;	/* enable pull-up on RB3 */
	RBPU = 0;		/* globally enable pull-ups on port b */
	
	IPEN = 0;
	INTCON = 0;
	INTCON2 = 0;
	INTCON3 = 0;
	IOCB = 0x10;
	
	T0CON = 0x8;
	TMR0ON = 1;
	
	TMR0IF = 0;
	TMR0IE = 0;
	
	RBIE = 1;
	RBIF = 0;
	
	if (PORTBbits.RB3) { gm = 0; pug = 1; }
	else { gm = 1; pug = 0; }
	
	lcd_init(FOURBIT_MODE);
	lcd_home();
	
	init_comms();
	
	i = 0;
	
	GIE = 1;
	
	while (1);		
}	

void interrupt isr(void) {
	static volatile char low;
	char validpreamble;
	
	if ((RBIE) && (RBIF)) {
		low = PORTB;						/* dummy read of port B */
			
		low = TMR0L;
		codelength[i] = TMR0H;
		codelength[i] = (codelength[i] << 8) | low;
		
		if (gm) {
			if (codelength[i] > 3200) preamblecount++;	
			else preamblecount = 0;
				
			if ((preamblecount > 10) && !valid && (codelength[i] > 6500)) { 
				codelength[0] = codelength[i];
				i=0;
				valid = 1;
				TMR0IF = 0;	TMR0IE = 1;					/* enable timer overflow interrupt */
			}
		}
		
		if (pug) {
			if ((codelength[i] > 300) && (codelength[i] < 600) && (codelength[i-1] > 800) && (codelength[i-1] < 1300)) preamblecount++;
			else if ((codelength[i-1] > 300) && (codelength[i-1] < 600) && (codelength[i] > 800) && (codelength[i] < 1300)) preamblecount++;
			else preamblecount = 0;
			
			if (!valid && pugincode && (codelength[i] > 3200)) {
				i=0;
				valid = 1;
				TMR0IF = 0;	TMR0IE = 1;					/* enable timer overflow interrupt */
			}
				
			if ((preamblecount > 20) && !pugincode && !valid) {
				/* we're now in the middle of the peugeot code, we've
					seen the header */
				pugincode = 1;
			}	
		}
			
		i++;
		if (i==512) i=0;
			
		TMR0H = 0; TMR0L = 0;	
		RBIF = 0;
	}	
	
	if ((TMR0IE) && (TMR0IF)) {
		/* we've got the code, now analyse it */
		TMR0IE = 0;
		TMR0IF = 0;
		RBIF = 0;
		RBIE = 0;
		GIE = 0;
			
		if (gm) gmanalysecode();
		else puganalysecode();
		
		i = 0;
		valid = 0;
		preamblecount = 0;
		pugincode = 0;

		RBIF = 0;
		RBIE = 1;
		GIE = 1;
	}	
}	